(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8229,        334]*)
(*NotebookOutlinePosition[      9085,        363]*)
(*  CellTagsIndexPosition[      9041,        359]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Variation of Parameters", "Subtitle"],

Cell[TextData[{
  "The function",
  StyleBox[" \t", "Input",
    FontWeight->"Plain"],
  StyleBox["VarPar[BasisOfKernel,RightHandSide, var]", "Input"],
  " , defined below, uses any ",
  StyleBox["basis of the kernel",
    FontVariations->{"Underline"->True}],
  " of the linear differential operator and the ",
  StyleBox["adjusted right hand side",
    FontVariations->{"Underline"->True}],
  " to produce a particular solution. The variable used is var.\".\n\nThis \
function is ",
  StyleBox["identical",
    FontVariations->{"Underline"->True}],
  " to the function defined in the Package ",
  StyleBox["VarPar.m",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text",
  PageWidth->PaperWidth,
  AspectRatioFixed->False,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
The adjusted right hand side is defined to be\
\>", "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      RowBox[{\(rhs\_adj\), "=", 
        RowBox[{
          
          StyleBox[\(\(actual\ right\ hand\ side\)\/\(leading\ \
coefficient\)\),
            FontSize->14], "."}]}]], "Input",
    Evaluatable->False]
}], "Text"],

Cell[TextData[{
  "For the DE   ",
  StyleBox["L[x_,y_]=", "Input"],
  StyleBox["a[x]y''[x]+b[x]y'[x]+c[x]y[x]\[Equal]rhs[x]", "Input"],
  ",   it would be"
}], "Text"],

Cell[TextData[Cell[BoxData[
    RowBox[{"\t", 
      RowBox[{\(rhs\_adj[x]\), "=", 
        RowBox[{
          StyleBox[\(rhs[x]\/a[x]\),
            FontSize->14], "."}]}]}]], "Input"]], "Text"],

Cell[TextData[{
  "If ",
  StyleBox["{y1[x],y2[x]}", "Input",
    FontWeight->"Bold"],
  " is a basis for the kernel of L, then the function call "
}], "Text"],

Cell[BoxData[
    RowBox[{\(yp[x_]\), "=", 
      RowBox[{"VarPar", "[", 
        RowBox[{
          StyleBox[\({y1[x], y2[x]}\),
            "Input",
            FontWeight->"Bold"], 
          StyleBox[",",
            "Input",
            FontWeight->"Bold"], \(rhs[x]\/a[x]\), ",", "x"}], 
        "]"}]}]], "Input"],

Cell[TextData[{
  "would produce ",
  StyleBox["yp[x]", "Input"],
  " as a particular solution of ",
  StyleBox["L[x,y]\[Equal]rhs[x].", "Input"]
}], "Text"],

Cell[CellGroupData[{

Cell["The function VarPar defined", "Section"],

Cell["\<\
Clear[VarPar]
VarPar[Ker_,fcn_,x_]:=
\tModule[{\ti,
\t\t\tw=Table[D[Ker,{x,i}],{i,0,Length[Ker]-1}],
\t\t\trhs=Join[Table[0,{i,1,Length[Ker]-1}],{fcn}]
\t\t\t},
\t\tSimplify[Ker.Integrate[Simplify[Inverse[w].rhs],x]]
\t]\
\>", "Input",
  AspectRatioFixed->False,
  ImageRegion->{{-0, 1}, {0, 1}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 5.28", "Section",
  Evaluatable->True],

Cell[BoxData[
    \(Clear[L, basis, W, x, yp, yc, c1, c2]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(L[x_, y_] = \(x\^2\) \(y''\)[x] - 4  x\ \(y'\)[x] + 6  y[x]\)], "Input"],

Cell[BoxData[
    RowBox[{\(6\ y[x]\), "-", 
      RowBox[{"4", " ", "x", " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{\(x\^2\), " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}]}]], "Output",
  Evaluatable->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(basis[x_] = {x\^2, x\^3}\)], "Input"],

Cell[BoxData[
    \({x\^2, x\^3}\)], "Output",
  Evaluatable->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(rhs[x_] = \((x - 1)\)\^2\)], "Input"],

Cell[BoxData[
    \(\((\(-1\) + x)\)\^2\)], "Output",
  Evaluatable->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(yp[x_] = VarPar[basis[x], rhs[x]\/x\^2, x]\)], "Input"],

Cell[BoxData[
    \(1\/6 - x - x\^2 - x\^2\ Log[x]\)], "Output",
  Evaluatable->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(yc[x_] = basis[x] . {c1, c2} + yp[x]\)], "Input"],

Cell[BoxData[
    \(1\/6 - x - x\^2 + c1\ x\^2 + c2\ x\^3 - x\^2\ Log[x]\)], "Output",
  Evaluatable->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Check.", "Subsection",
  Evaluatable->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(L[x, yc] \[Equal] rhs[x] // Simplify\)], "Input"],

Cell[BoxData[
    \(True\)], "Output",
  Evaluatable->True]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercise 3", "Section"],

Cell[BoxData[
    \(Clear[basis, x, y, L, yp]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(L[x_, y_] = \(y''\)[x] + 4 \( y'\)[x] - 5  y[x]\)], "Input"],

Cell[BoxData[
    RowBox[{\(\(-5\)\ y[x]\), "+", 
      RowBox[{"4", " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{
        SuperscriptBox["y", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]}]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(rhs = Sin[x]\)], "Input"],

Cell[BoxData[
    \(Sin[x]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(basis = {\[ExponentialE]\^\(\(-5\) x\), \[ExponentialE]\^x}\)], "Input"],

Cell[BoxData[
    \({\[ExponentialE]\^\(\(-5\)\ x\), \[ExponentialE]\^x}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Particular solution", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(yp[x_] = VarPar[basis, rhs, x]\)], "Input"],

Cell[BoxData[
    \(1\/26\ \((\(-2\)\ Cos[x] - 3\ Sin[x])\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(soln[x_] = basis . {c1, c2} + yp[x]\)], "Input"],

Cell[BoxData[
    \(c1\ \[ExponentialE]\^\(\(-5\)\ x\) + c2\ \[ExponentialE]\^x + 
      1\/26\ \((\(-2\)\ Cos[x] - 3\ Sin[x])\)\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Check", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(L[x, soln] \[Equal] rhs\)], "Input"],

Cell[BoxData[
    \(25\ c1\ \[ExponentialE]\^\(\(-5\)\ x\) + c2\ \[ExponentialE]\^x - 
        5\ \((c1\ \[ExponentialE]\^\(\(-5\)\ x\) + c2\ \[ExponentialE]\^x + 
              1\/26\ \((\(-2\)\ Cos[x] - 3\ Sin[x])\))\) + 
        1\/26\ \((2\ Cos[x] + 3\ Sin[x])\) + 
        4\ \((\(-5\)\ c1\ \[ExponentialE]\^\(\(-5\)\ x\) + 
              c2\ \[ExponentialE]\^x + 
              1\/26\ \((\(-3\)\ Cos[x] + 2\ Sin[x])\))\) == 
      Sin[x]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(L[x, soln] \[Equal] rhs // Simplify\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
WindowSize->{520, 624},
WindowMargins->{{36, Automatic}, {16, Automatic}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 43, 0, 65, "Subtitle"],
Cell[1822, 55, 775, 23, 104, "Text"],
Cell[2600, 80, 69, 2, 32, "Text"],
Cell[2672, 84, 265, 10, 37, "Text"],
Cell[2940, 96, 168, 5, 50, "Text"],
Cell[3111, 103, 195, 5, 37, "Text"],
Cell[3309, 110, 159, 5, 32, "Text"],
Cell[3471, 117, 320, 10, 44, "Input"],
Cell[3794, 129, 157, 5, 32, "Text"],

Cell[CellGroupData[{
Cell[3976, 138, 46, 0, 56, "Section"],
Cell[4025, 140, 306, 11, 177, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[4368, 156, 52, 1, 36, "Section",
  Evaluatable->True],
Cell[4423, 159, 70, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[4518, 164, 92, 1, 29, "Input"],
Cell[4613, 167, 389, 10, 29, "Output",
  Evaluatable->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[5039, 182, 57, 1, 31, "Input"],
Cell[5099, 185, 67, 2, 29, "Output",
  Evaluatable->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[5203, 192, 57, 1, 29, "Input"],
Cell[5263, 195, 74, 2, 29, "Output",
  Evaluatable->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[5374, 202, 75, 1, 42, "Input"],
Cell[5452, 205, 85, 2, 42, "Output",
  Evaluatable->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[5574, 212, 69, 1, 27, "Input"],
Cell[5646, 215, 107, 2, 42, "Output",
  Evaluatable->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[5790, 222, 49, 1, 46, "Subsection",
  Evaluatable->True],

Cell[CellGroupData[{
Cell[5864, 227, 69, 1, 27, "Input"],
Cell[5936, 230, 59, 2, 27, "Output",
  Evaluatable->True]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[6056, 239, 29, 0, 36, "Section"],
Cell[6088, 241, 58, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[6171, 246, 80, 1, 27, "Input"],
Cell[6254, 249, 325, 8, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6616, 262, 45, 1, 27, "Input"],
Cell[6664, 265, 40, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6741, 271, 92, 1, 31, "Input"],
Cell[6836, 274, 86, 1, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6959, 280, 41, 0, 46, "Subsection"],

Cell[CellGroupData[{
Cell[7025, 284, 63, 1, 27, "Input"],
Cell[7091, 287, 73, 1, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7201, 293, 68, 1, 27, "Input"],
Cell[7272, 296, 142, 2, 42, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7463, 304, 27, 0, 46, "Subsection"],

Cell[CellGroupData[{
Cell[7515, 308, 56, 1, 27, "Input"],
Cell[7574, 311, 457, 8, 110, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[8068, 324, 68, 1, 27, "Input"],
Cell[8139, 327, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

